@extends('layouts.app')

@section('content')
<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark">Tolerance<small class="ml-3 mr-3">|</small><small>Tolerance</small></h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="{{url('/dashboard')}}"><i class="fa fa-dashboard"></i> {{trans('lang.dashboard')}}</a></li>
          <li class="breadcrumb-item"><a href="{!! route('tolerance.index') !!}">Tolerance</a>
          </li>
          <li class="breadcrumb-item active">Tolerance</li>
        </ol>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="content">
  <div class="clearfix"></div>
  @include('flash::message')
  <div class="card">
    <div class="card-header">
      <ul class="nav nav-tabs align-items-end card-header-tabs w-100">
        <li class="nav-item">
          <a class="nav-link active" href="{!! url()->current() !!}"><i class="fa fa-list mr-2"></i>Tolerance</a>
        </li>
        @can('tolerance.create')
        <li class="nav-item">
          <a class="nav-link" href="{!! route('tolerance.create') !!}"><i class="fa fa-plus mr-2"></i>Tolerance</a>
        </li>
        @endcan
        <!--@can('vehicle.store')-->
        <!--<li class="nav-item">-->
        <!--  <a class="nav-link" href="{!! route('vehicle.store') !!}"><i class="fa fa-plus mr-2"></i>{{trans('lang.vehicle_store')}}</a>-->
        <!--</li>-->
        <!--@endcan-->
      </ul>
    </div>
    <div class="card-body">
       <div class="table-responsive">
                      <table class="table" id="example1">
                          <thead>
                              <tr>
                                  <th>ID</th>
                                  <th>Excess Tolerance</th>
                                  <th>Shortest Tolerance</th>
                                  <th>Created date</th>
                                  <th>Action</th>
                              </tr>
                          </thead>
                          <tbody>
                    @if(count($tolerance)>0)
                    @foreach ($tolerance as $key=>$tole)
                              <tr>
                                  <th scope="row">{{ $tole->id }}</th>
                                  <td>{{ $tole->tolerance_percent }}</td>
                                  <td>{{ $tole->shortest_tolerance }}</td>
                                  <td>{{ $tole->created }}</td>
                                  <td><a data-toggle="tooltip" data-placement="bottom" title="Edit" href="tolerance/edit/{{ $tole->id }}" class="badge bg-light-blue"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a> 
                            <a data-toggle="tooltip" data-placement="bottom" title="Delete" href="tolerance/destroy/{{ $tole->id }}" class="badge bg-red" onclick="return confirm('Are you sure?')"><i class="fa fa-trash" aria-hidden="true"></i></a></td>
                              </tr>
                               @endforeach
                    @else
                       <tr>
                            <td colspan="6">No record found!</td>
                       </tr>
                    @endif
                          </tbody>
                      </table>
                       <div class="col-xs-12 pull-right">
                	{{$tolerance->links()}}
                </div>
                  </div>
      <div class="clearfix"></div>
    </div>
  </div>
</div>
@endsection