@extends('layouts.app')
@push('css_lib')
  <!-- iCheck -->
  <link rel="stylesheet" href="{{asset('plugins/iCheck/flat/blue.css')}}">
  <!-- select2 -->
  <link rel="stylesheet" href="{{asset('plugins/select2/select2.min.css')}}">
  <!-- bootstrap wysihtml5 - text editor -->
  <link rel="stylesheet" href="{{asset('plugins/summernote/summernote-bs4.css')}}">
  {{--dropzone--}}
  <link rel="stylesheet" href="{{asset('plugins/dropzone/bootstrap.min.css')}}">
@endpush
@section('title','Push Notification')
@section('content')
  @include('flash::message')
  @include('adminlte-templates::common.errors')
  <div class="clearfix"></div>
  <div class="card">
    <div class="card-header">
      <ul class="nav nav-tabs align-items-end card-header-tabs w-100">
        <!--<li class="nav-item">-->
        <!--  <a class="nav-link" href="{!! route('pushnotification.index') !!}"><i class="fa fa-list mr-2"></i>Push Notification</a>-->
        <!--</li>-->
        <li class="nav-item">
          <a class="nav-link active" href="{!! url()->current() !!}"><i class="fa fa-plus mr-2"></i>Push Notification</a>
        </li>
      </ul>
    </div>
    <div class="card-body">
      {!! Form::open(['route' => 'pushnotification.store']) !!}
      <div class="row">
<div style="flex: 100%;max-width: 100%;padding: 0 4px;" class="row">
    <!-- Name Field -->
    <div class="form-group row col-6">
        {!! Form::label('title', 'Title', ['class' => 'col-5 control-label text-right']) !!}
        <div class="col-7">
            {!! Form::text('title', null,  ['class' => 'form-control','placeholder'=>  'Title', "required"=>"true"]) !!}
            <div class="form-text text-muted">
               Title
            </div>
        </div>
    </div>
        <div class="form-group row col-6">
        {!! Form::label('description', 'Description', ['class' => 'col-5 control-label text-right']) !!}
        <div class="col-7">
            {!! Form::text('description', null,  ['class' => 'form-control','placeholder'=>  'Description', "required"=>"true"]) !!}
            <div class="form-text text-muted">
                Description
            </div>
        </div>
    </div>
    <div class="form-group row col-6">
        {!! Form::label('status','Type', ['class' => 'col-5 control-label text-right']) !!}
        <div class="col-7">
            <select class="form-control" required="true" name="type" id="status">
            <option value="all">All</option>     
            <option value="0">Android</option>  
            <option value="1">IOS</option> 
            </select>
            <div class="form-text text-muted">
                Type
            </div>
        </div>
    </div>
</div>
<!-- Submit Field -->
<div class="form-group col-12 text-right">
    <button type="submit" class="btn btn-{{setting('theme_color')}}"><i class="fa fa-save"></i> Submit</button>
    <!--<a href="{!! route('label_description.index') !!}" class="btn btn-default"><i class="fa fa-undo"></i> {{trans('lang.cancel')}}</a>-->
</div>

      </div>
      {!! Form::close() !!}
      <div class="clearfix"></div>
    </div>
  </div>
</div>
@include('layouts.media_modal',['collection'=>null])
@endsection
@push('scripts_lib')
<!-- iCheck -->
<script src="{{asset('plugins/iCheck/icheck.min.js')}}"></script>
<!-- select2 -->
<script src="{{asset('plugins/select2/select2.min.js')}}"></script>
<!-- AdminLTE dashboard demo (This is only for demo purposes) -->
<script src="{{asset('plugins/summernote/summernote-bs4.min.js')}}"></script>
{{--dropzone--}}
<script src="{{asset('plugins/dropzone/dropzone.js')}}"></script>
<script type="text/javascript">
    Dropzone.autoDiscover = false;
    var dropzoneFields = [];
</script>
@endpush