@extends('layouts.app')

@section('content')
<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark">Products<small class="ml-3 mr-3">|</small><small>Products List</small></h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="{{url('/dashboard')}}"><i class="fa fa-dashboard"></i> {{trans('lang.dashboard')}}</a></li>
          <li class="breadcrumb-item"><a href="{!! route('productsavailable.index') !!}">Products</a>
          </li>
          <li class="breadcrumb-item active">Products List</li>
        </ol>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="content">
  <div class="clearfix"></div>
  @include('flash::message')
  <div class="card">
    <div class="card-header">
      <ul class="nav nav-tabs align-items-end card-header-tabs w-100">
        <li class="nav-item">
          <a class="nav-link active" href="{!! url()->current() !!}"><i class="fa fa-list mr-2"></i>Products List</a>
        </li>
      </ul>
    </div>
    <div class="card-body">
       <div class="table-responsive">
                      <table class="table" id="example1">
                          <thead>
                              <tr>
                                  <th>ID</th>
                                  <th>Item Barcode</th>
                                  <th>Product Name</th>
                                  <th>Item Number</th>
                                  <th> Unit Code</th>
                                  <th>Salable Quantity</th>
                              </tr>
                          </thead>
                          <tbody>
                    @if(count($productsavailable)>0)
                    @foreach ($productsavailable as $key=>$productsavailable1)
                              <tr>
                                  <th scope="row">{{ $productsavailable1->entity_id }}</th>
                                  <td>{{ $productsavailable1->sku }}</td>
                                 <td>{{ $productsavailable1->product_name }}</td>
                                 <td>{{ $productsavailable1->item_number }}</td>
                                 <td>{{ $productsavailable1->unit_code }}</td>
                                 <td>{{ $productsavailable1->salableqty }}</td>
                              </tr>
                               @endforeach
                    @else
                       <tr>
                            <td colspan="6">No record found!</td>
                       </tr>
                    @endif
                          </tbody>
                      </table>
                       <div class="col-xs-12 pull-right">
                    	<div style="display:flex;justify-content: space-between;">
                             <span>
                                 Showing 1 to {{ $perPage }} of {{ $productsavailable->total() }} entries
                            </span>
                             <span>
                                 {!! $productsavailable->links() !!}
                             </span>
                        </div>
                </div>
                  </div>
      <div class="clearfix"></div>
    </div>
  </div>
</div>
@endsection