@extends('layouts.app')

@section('content')
<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark">Multistore<small class="ml-3 mr-3">|</small><small>ERP Inventory Lists</small></h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="{{url('/dashboard')}}"><i class="fa fa-dashboard"></i> {{trans('lang.dashboard')}}</a></li>
          <li class="breadcrumb-item"><a href="{!! route('erpinventory.index') !!}">Multistore</a>
          </li>
          <li class="breadcrumb-item active">ERP Inventory Lists</li>
        </ol>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="content">
  <div class="clearfix"></div>
  @include('flash::message')
  <div class="card">
    <div class="card-header">
      <ul class="nav nav-tabs align-items-end card-header-tabs w-100">
        <li class="nav-item">
          <a class="nav-link active" href="{!! url()->current() !!}"><i class="fa fa-list mr-2"></i>Erp Inventory Lists</a>
        </li>
      </ul>
      <div class="float-right">
        <form action="{{ route('erpinventory.index') }}" method="GET">
           <div class="input-group input-group-sm">
                <input type="search" value="<?php echo isset($_GET["search"])? $_GET["search"] : '' ?>" name="search" class="form-control" placeholder="Item Barcode Search" aria-label="Search">
            <div class="input-group-append">
                <button class="input-group-text" style="cursor:pointer" type="submit"><i class="fa fa-search"></i></button>
            </div>
          </div>
        </form>
      </div>
      <!--<button type="button" onclick="exportTableToCSV('erpinventory.csv')" id="csv" class="btn btn-secondary float-right mr-3">CSV</button>-->
      <!--<button type="button" id="excel" class="btn btn-success float-right mr-1">Excel</button>-->
    </div>
    <div class="card-body">
       <div class="table-responsive">
                      <table class="table" id="example1">
                          <thead>
                              <tr>
                                  <th>ID</th>
                                  <th>Item Barcode</th>
                                  <th>Product Name</th>
                                  <th>Item Number</th>
                                  <th>Unit Code</th>
                                  <th>ERP Store Code</th>
                                  <th>Store Name</th>
                                  <th>Inventory</th>
                                  <th>Action</th>
                              </tr>
                          </thead>
                          <tbody>
                    @inject('products','\DB')
                    @if(count($erpinventory)>0)
                        @for($i=0;$i<count($erpinventory);$i++)
                                  <tr>
                                      <th scope="row">{{ $erpinventory[$i]->id }}</th>
                                      <td>{{ $erpinventory[$i]->barcode }}</td>
                                     <td>
                                        <?php 
                                             $getitemid = $products::table('catalog_product_entity')->where('sku',$erpinventory[$i]->barcode)->select('entity_id')->first();
                                             $currentEntityId = isset($getitemid->entity_id)?$getitemid->entity_id:"";
                                             $itemnumber = $products::table('catalog_product_entity_varchar')->where('entity_id',$currentEntityId)->where('attribute_id',73)->first();
                                             echo isset($itemnumber->value)?$itemnumber->value:"-";
                                        ?>
                                     </td>
                                     <td>{{ $erpinventory[$i]->itemcode }}</td>
                                     <td>
                                         {{ $erpinventory[$i]->unitofmeasurecode }}
                                     </td>
                                     <td>
                                        {{ $erpinventory[$i]->storecode }}
                                     </td>
                                     <td>
                                        <?php 
                                             $storename = $products::table('store_group')->where('group_id',$erpinventory[$i]->magento_storecode)->select('name')->first();
                                             echo isset($storename->name)?$storename->name: "-";
                                        ?>
                                     </td>
                                     <td>{{ $erpinventory[$i]->inventory }}</td>
                                     <td><a data-toggle="tooltip" data-placement="bottom" title="Edit Inventory" href="erpinventory/edit/{{ $erpinventory[$i]->id }}" class="badge bg-light-blue"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a> 
                                  </tr>
                        @endfor
                    @else
                       <tr>
                            <td colspan="6">No record found!</td>
                       </tr>
                    @endif
                          </tbody>
                      </table>
                       <div class="col-xs-12">
                    	<div style="display:flex;align-items:center;justify-content: space-between;">
                             <span>
                                 Showing 1 to {{ $perPage }} of {{ $erpinventory->total() }} entries
                            </span>
                             <span>
                                 {!! $erpinventory->appends($_GET)->links() !!}
                             </span>
                        </div>
                </div>
                  </div>
      <div class="clearfix"></div>
    </div>
  </div>
</div>
@endsection
@push('scripts_lib')
    <!-- iCheck -->
   <script src = "https://code.jquery.com/jquery-1.10.2.js"></script>
      <script src = "https://code.jquery.com/ui/1.10.4/jquery-ui.js"></script>
    <script src="{{asset('plugins/iCheck/icheck.min.js')}}"></script>
    <!-- select2 -->
    <script src="{{asset('plugins/select2/select2.min.js')}}"></script>
    <!-- AdminLTE dashboard demo (This is only for demo purposes) -->
    <script src="{{asset('plugins/summernote/summernote-bs4.min.js')}}"></script>
    {{--dropzone--}}
    <script src="{{asset('plugins/dropzone/dropzone.js')}}"></script>
    <script type="text/javascript">
        Dropzone.autoDiscover = false;
        var dropzoneFields = [];
    </script>
<link href="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css" rel="stylesheet" />
<script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>


<!--Excel Library-->
<script>
    /*
 *  jQuery table2excel - v1.0.2
 *  jQuery plugin to export an .xls file in browser from an HTML table
 *  https://github.com/rainabba/jquery-table2excel
 *
 *  Made by rainabba
 *  Under MIT License
 */
!function(a,b,c,d){function e(b,c){this.element=b,this.settings=a.extend({},k,c),this._defaults=k,this._name=j,this.init()}function f(a){return a.filename?a.filename:"table2excel"}function g(a){var b=/(\s+alt\s*=\s*"([^"]*)"|\s+alt\s*=\s*'([^']*)')/i;return a.replace(/<img[^>]*>/gi,function(a){var c=b.exec(a);return null!==c&&c.length>=2?c[2]:""})}function h(a){return a.replace(/<a[^>]*>|<\/a>/gi,"")}function i(a){var b=/(\s+value\s*=\s*"([^"]*)"|\s+value\s*=\s*'([^']*)')/i;return a.replace(/<input[^>]*>|<\/input>/gi,function(a){var c=b.exec(a);return null!==c&&c.length>=2?c[2]:""})}var j="table2excel",k={exclude:".noExl",name:"Table2Excel"};e.prototype={init:function(){var b=this;b.template={head:'<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><meta http-equiv="content-type" content="application/vnd.ms-excel; charset=UTF-8"><head>\x3c!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets>',sheet:{head:"<x:ExcelWorksheet><x:Name>",tail:"</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet>"},mid:"</x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--\x3e</head><body>",table:{head:"<table>",tail:"</table>"},foot:"</body></html>"},b.tableRows=[],a(b.element).each(function(c,d){var e="";a(d).find("tr").not(b.settings.exclude).each(function(c,d){e+="<tr>",a(d).find("td,th").not(b.settings.exclude).each(function(c,d){a(d).find(b.settings.exclude).length>=1?e+="<td> </td>":e+="<td>"+a(d).html()+"</td>"}),e+="</tr>"}),b.settings.exclude_img&&(e=g(e)),b.settings.exclude_links&&(e=h(e)),b.settings.exclude_inputs&&(e=i(e)),b.tableRows.push(e)}),b.tableToExcel(b.tableRows,b.settings.name,b.settings.sheetName)},tableToExcel:function(d,e,g){var h,i,j,k=this,l="";if(k.format=function(a,b){return a.replace(/{(\w+)}/g,function(a,c){return b[c]})},g=void 0===g?"Sheet":g,k.ctx={worksheet:e||"Worksheet",table:d,sheetName:g},l=k.template.head,a.isArray(d))for(h in d)l+=k.template.sheet.head+g+h+k.template.sheet.tail;if(l+=k.template.mid,a.isArray(d))for(h in d)l+=k.template.table.head+"{table"+h+"}"+k.template.table.tail;l+=k.template.foot;for(h in d)k.ctx["table"+h]=d[h];if(delete k.ctx.table,!c.documentMode){var m=new Blob([k.format(l,k.ctx)],{type:"application/vnd.ms-excel"});b.URL=b.URL||b.webkitURL,i=b.URL.createObjectURL(m),j=c.createElement("a"),j.download=f(k.settings),j.href=i,c.body.appendChild(j),j.click(),c.body.removeChild(j)}else if("undefined"!=typeof Blob){l=k.format(l,k.ctx),l=[l];var n=new Blob(l,{type:"text/html"});b.navigator.msSaveBlob(n,f(k.settings))}else txtArea1.document.open("text/html","replace"),txtArea1.document.write(k.format(l,k.ctx)),txtArea1.document.close(),txtArea1.focus(),sa=txtArea1.document.execCommand("SaveAs",!0,f(k.settings));return!0}},a.fn[j]=function(b){var c=this;return c.each(function(){a.data(c,"plugin_"+j)||a.data(c,"plugin_"+j,new e(this,b))}),c}}(jQuery,window,document);
</script>

<!--PDF Library-->
<!--<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.22/pdfmake.min.js"></script>-->
<!--<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/0.4.1/html2canvas.min.js"></script>-->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.3/jspdf.min.js"></script>
<script src="https://html2canvas.hertzen.com/dist/html2canvas.js"></script>


<!--CSV Library-->
<script>
    
</script>
<script>
$( function() {
    $( "#datepicker" ).datepicker({ dateFormat: 'yy-mm-dd' }).val();
    $( "#datepicker1" ).datepicker({ dateFormat: 'yy-mm-dd' }).val();
});

$("#excel").click(function () {
    $("#example1").table2excel({
        filename: "erpinventory.xls"
    });
});

// $("#pdf").click(function () {
//   html2canvas($('#example1')[0], {
//         onrendered: function (canvas) {
//                     var data = canvas.toDataURL();
//                     var docDefinition = {
//                         content: [{
//                             image: data,
//                             width: 500
//                         }]
//                     };
//                     pdfMake.createPdf(docDefinition).download("reports_payment.pdf");
//                 }
//   });
// });

$("#pdf").click(function () {
    $("#pdf").html("<i class='fa fa-refresh fa-spin spinning'></i> Wait");
    var HTML_Width = $("#example1").width();
    		var HTML_Height = $("#example1").height();
    		var top_left_margin = 15;
    		var PDF_Width = HTML_Width+(top_left_margin*2);
    		var PDF_Height = (PDF_Width*1.5)+(top_left_margin*2);
    		var canvas_image_width = HTML_Width;
    		var canvas_image_height = HTML_Height;
    		
    		var totalPDFPages = Math.ceil(HTML_Height/PDF_Height)-1;
    		
    
    		html2canvas($("#example1")[0],{allowTaint:true}).then(function(canvas) {
    			canvas.getContext('2d');
    			
    			console.log(canvas.height+"  "+canvas.width);
    			
    			
    			var imgData = canvas.toDataURL("image/jpeg", 1.0);
    			var pdf = new jsPDF('p', 'pt',  [PDF_Width, PDF_Height]);
    		    pdf.addImage(imgData, 'JPG', top_left_margin, top_left_margin,canvas_image_width,canvas_image_height);
    			
    			
    			for (var i = 1; i <= totalPDFPages; i++) { 
    				pdf.addPage(PDF_Width, PDF_Height);
    				pdf.addImage(imgData, 'JPG', top_left_margin, -(PDF_Height*i)+(top_left_margin*4),canvas_image_width,canvas_image_height);
    			}
    			
    		    if(pdf.save("reports_payment.pdf")){
    		        $("#pdf").html("PDF");
    		    }else{
    		      //  alert('Failed to generate the PDF!');
    		        $("#pdf").html("PDF");
    		    }
    });
});


// CSV Convert

const toCsv = function(table) {
    // Query all rows
    const rows = table.querySelectorAll('tr');

    return [].slice.call(rows)
        .map(function(row) {
            // Query all cells
            const cells = row.querySelectorAll('th,td');
            return [].slice.call(cells)
                .map(function(cell) {
                    return cell.textContent;
                })
                .join(',');
        })
        .join('\n');
};

const download = function(text, fileName) {
    const link = document.createElement('a');
    link.setAttribute('href', `data:text/csv;charset=utf-8,${encodeURIComponent(text)}`);
    link.setAttribute('download', fileName);

    link.style.display = 'none';
    document.body.appendChild(link);

    link.click();

    document.body.removeChild(link);
};

const table = document.getElementById('example1');
const exportBtn = document.getElementById('csv');

exportBtn.addEventListener('click', function() {
    // Export to csv
    const csv = toCsv(table);

    // Download it
    download(csv, 'erpinventory.csv');
});


</script>

@endpush